/*
 * Decompiled with CFR 0.152.
 */
package jace;

import jace.EmulatorUILogic;
import jace.apple2e.Apple2e;
import jace.config.Configuration;
import jace.core.Computer;
import jace.ui.MainFrame;
import java.awt.Canvas;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class Emulator {
    public static Emulator instance;
    public Apple2e computer = new Apple2e();

    public static void main(String[] args) {
        instance = new Emulator();
    }

    public Emulator() {
        Configuration.loadSettings();
        MainFrame theApp = new MainFrame();
        try {
            theApp.setIconImage(ImageIO.read(Emulator.class.getClassLoader().getResourceAsStream("jace/data/woz_figure.gif")));
        }
        catch (IOException ex) {
            Logger.getLogger(Emulator.class.getName()).log(Level.SEVERE, null, ex);
        }
        theApp.setVisible(true);
        theApp.setDefaultCloseOperation(3);
        theApp.setFocusTraversalKeysEnabled(false);
        theApp.screen.setFocusTraversalKeysEnabled(false);
        theApp.setTitle("Java Apple Computer Emulator");
        Emulator.resizeVideo();
        theApp.addKeyListener(this.computer.getKeyboard().getListener());
        theApp.screen.addKeyListener(this.computer.getKeyboard().getListener());
        theApp.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                Emulator.resizeVideo();
            }

            public void componentMoved(ComponentEvent e) {
                Emulator.resizeVideo();
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        theApp.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
                Computer.getComputer().getVideo().suspend();
            }

            public void windowDeiconified(WindowEvent e) {
                Computer.getComputer().getVideo().resume();
                Emulator.resizeVideo();
            }

            public void windowActivated(WindowEvent e) {
                Emulator.resizeVideo();
            }

            public void windowDeactivated(WindowEvent e) {
                Emulator.resizeVideo();
            }
        });
        EmulatorUILogic.registerDebugger();
        this.computer.getVideo().setScreen(theApp.screen.getGraphics());
        this.computer.coldStart();
    }

    public static void resizeVideo() {
        MainFrame window = MainFrame.instance;
        JPanel debugger = MainFrame.instance.debugger;
        Canvas screen = MainFrame.instance.screen;
        screen.setSize(window.getContentPane().getWidth() - debugger.getWidth() + 1, window.getContentPane().getHeight());
        Computer.getComputer().getVideo().setWidth(screen.getWidth());
        Computer.getComputer().getVideo().setHeight(screen.getHeight());
        debugger.revalidate();
        Computer.getComputer().getVideo().markDirty();
    }
}

